/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2010 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package com.genesyslab.samples.interceptor;

import com.genesyslab.ail.Agent;
import com.genesyslab.ail.Contact;
import com.genesyslab.ail.Interaction;

/**
 * This class is used to implement the behavior that must be executed when a user visualizes interaction history record.
 * In this sample the behavior consists in calling a primitive of the AuditFileManager that writes 
 * timestamp, interaction ID, related contact ID if any and user name in a plain text file.
 * In configuration file interceptor.xml it is configured in this XML fragment:
 *      <interceptor name="VIEW_HISTORY_INTERACTION" implementation-class="com.genesyslab.samples.interceptor.ViewHistoryInteraction" method="execute">
 *          <property name="agent"/>
 *          <property name="contact"/>
 *          <property name="interaction"/>
 *      </interceptor>
 */
public class ViewHistoryInteraction {
    private Agent agent;
    private Contact contact;
    private Interaction interaction;
    
    /**
     * Called by interceptor framework prior to call to "execute" method.
     * This is a standard attribute.
     */
    public void setContact(Contact contact) {
        this.contact = contact;
    }
    
    /**
     * Called by interceptor framework prior to call to "execute" method.
     * This is a standard attribute.
     */
    public void setInteraction(Interaction interaction) {
        this.interaction = interaction;
    }
    
    /**
     * Called by interceptor framework prior to call to "execute" method.
     * This is a standard attribute.
     */
    public void setAgent(Agent myAgent) {
        this.agent = myAgent;
    }
    
    /**
     * This method is referenced as attribute "method" in corresponding interceptor.xml tag.
     * It is called automatically by the framework after all the "in" properties have been set
     * thanks to the set method declared above.
     */
    public void execute() {
        AuditFileManager mgr = AuditFileManager.getInstance();
        String contactId = contact!=null ? contact.getId() : "unknown";
        mgr.append("Agent "+agent.getId()+" is accessing interaction "+interaction.getId()+" of contact "+contactId);
    }
}
